﻿using System;

public class DelegatesAndEvents
{
    public static int Main(string[] args)
    {
        // tworzenie głównego menu
        Menu myMenu = new Menu("Strony finansowe");

        // tworzenie obiektu danych
        SiteManager sm = new SiteManager();

        // tworzenie elementów menu
        MenuItem addMenu = new MenuItem("Dodanie");
        MenuItem delMenu = new MenuItem("Usunięcie");
        MenuItem modMenu = new MenuItem("Modyfikacja");
        MenuItem seeMenu = new MenuItem("Widok");

        // dodawanie zdarzeń
        addMenu.MenuSelection += new MenuHandler(sm.AddSite);
        delMenu.MenuSelection += new MenuHandler(sm.DeleteSite);
        modMenu.MenuSelection += new MenuHandler(sm.ModifySite);
        seeMenu.MenuSelection += new MenuHandler(sm.ViewSites);

        // tworzenie menu w oparciu o dostarczone elementy
        myMenu.Add(addMenu);
        myMenu.Add(delMenu);
        myMenu.Add(modMenu);
        myMenu.Add(seeMenu);

        // aktywacja menu i oczekiwanie na działania użytkownika
        myMenu.Run();

        return 0;
    }
}
